/*** HOW TO FIT AN MCMC MODEL ***/

/*** STEP 1: DATA PREPARATION ***/

/***********************************************************************************************************************************************************************/
/*** 1a. To get intakes for foods, merge NHANES data with FPED data                                                                                                  ***/
/*** NOTE: The files fped_dr1tot_1112 and fped_dr2tot_112 have ALREADY been merged with the FPED                                                                     ***/
/***       See https://www.ars.usda.gov/northeast-area/beltsville-md/beltsville-human-nutrition-research-center/food-surveys-research-group/docs/fped-databases/ for ***/
/***       datafiles (from fped_dr1tot_1112.sas.exe and fped_dr2tot_1112.sas.exe                                                                                     ***/
/***********************************************************************************************************************************************************************/

libname usda 'H:\Usual Intake\HEI\nhanes 1112\fped';   *replace with the name of the folder where you have downloaded the extracted data;
libname import 'H:\Usual Intake\HEI\nhanes 1112\data\';*replace with the name of the folder where you have downloaded the extracted data;

data day1_foods;
set usda.fped_dr1tot_1112(RENAME=(DR1T_F_CITMLB=F_CITMLB DR1T_F_OTHER=F_OTHER DR1T_F_JUICE=F_JUICE DR1T_F_TOTAL=F_TOTAL
DR1T_G_WHOLE=G_WHOLE DR1T_G_REFINED=G_REFINED DR1T_D_TOTAL=D_TOTAL DR1T_PF_MPS_TOTAL=PF_MPS_TOTAL DR1T_PF_EGGS=PF_EGGS DR1T_PF_NUTSDS=PF_NUTSDS
DR1T_PF_SOY=PF_SOY DR1T_PF_LEGUMES=PF_LEGUMES DR1T_PF_SEAFD_HI=PF_SEAFD_HI DR1T_PF_SEAFD_LOW=PF_SEAFD_LOW DR1T_PF_TOTAL=PF_TOTAL
DR1T_V_DRKGR=V_DRKGR DR1T_V_LEGUMES=V_LEGUMES DR1T_V_TOTAL=V_TOTAL DR1T_ADD_SUGARS=ADD_SUGARS));

DAY=1;
FWHOLEFRT=F_CITMLB+F_OTHER;
VDRKGRLEG=V_DRKGR+V_LEGUMES; 
VTOTALLEG=V_TOTAL+V_LEGUMES;
VNONDRKGR=round(V_TOTAL - V_DRKGR,0.01);
PFSEAPLANTLEG=PF_SEAFD_HI+PF_SEAFD_LOW+PF_SOY+PF_NUTSDS+PF_LEGUMES;
PFALLPROTLEG=PF_MPS_TOTAL+PF_EGGS+PF_NUTSDS+PF_SOY+PF_LEGUMES;
PFSEASOYNUT=round(PFSEAPLANTLEG - PF_LEGUMES,0.01);
PFMPEGGS=round(PFALLPROTLEG - PFSEAPLANTLEG,0.01);
IF PFMPEGGS<0 and PFMPEGGS ne . then PFMPEGGS=0;
IF VNONDRKGR<0 and VNONDRKGR ne . then VNONDRKGR=0;
IF PFSEASOYNUT<0 and PFSEASOYNUT ne . then PFSEASOYNUT=0;

LABEL DAY='Day of Recall'
      FWHOLEFRT='Whole Fruit'
	  VDRKGRLEG='Dark Green Vegetables and Legumes'
	  VTOTALLEG='Total Vegetables (inc Legumes)'
	  VNONDRKGR='Vegetables without Greens (w/o Legumes)'
  	  PFSEAPLANTLEG='Seafood and Plant Proteins (inc Legumes)'
	  PFALLPROTLEG='All Protein (inc Legumes)'
	  PFSEASOYNUT='Seafood, Soy, and Nuts (w/o Legumes)'
	  PFMPEGGS='Meat, Poultry, and Eggs (w/o Legumes)'  ;

keep SEQN F_JUICE F_TOTAL PF_MPS_TOTAL V_DRKGR V_LEGUMES G_WHOLE G_REFINED D_TOTAL PF_LEGUMES ADD_SUGARS
F_CITMLB F_OTHER V_TOTAL PF_SEAFD_HI PF_SEAFD_LOW PF_SOY PF_NUTSDS PF_EGGS PF_TOTAL
FWHOLEFRT VDRKGRLEG VTOTALLEG VNONDRKGR PFSEAPLANTLEG PFALLPROTLEG PFSEASOYNUT PFMPEGGS;
run;


data day2_foods;
set usda.fped_dr2tot_1112(RENAME=(DR2T_F_CITMLB=F_CITMLB DR2T_F_OTHER=F_OTHER DR2T_F_JUICE=F_JUICE DR2T_F_TOTAL=F_TOTAL 
DR2T_G_WHOLE=G_WHOLE DR2T_G_REFINED=G_REFINED DR2T_D_TOTAL=D_TOTAL DR2T_PF_MPS_TOTAL=PF_MPS_TOTAL DR2T_PF_EGGS=PF_EGGS DR2T_PF_NUTSDS=PF_NUTSDS
DR2T_PF_SOY=PF_SOY DR2T_PF_LEGUMES=PF_LEGUMES DR2T_PF_SEAFD_HI=PF_SEAFD_HI DR2T_PF_SEAFD_LOW=PF_SEAFD_LOW DR2T_PF_TOTAL=PF_TOTAL 
DR2T_V_DRKGR=V_DRKGR DR2T_V_LEGUMES=V_LEGUMES DR2T_V_TOTAL=V_TOTAL DR2T_ADD_SUGARS=ADD_SUGARS));

DAY=2;
FWHOLEFRT=F_CITMLB+F_OTHER;
VDRKGRLEG=V_DRKGR+V_LEGUMES; 
VTOTALLEG=V_TOTAL+V_LEGUMES;
VNONDRKGR=round(V_TOTAL - V_DRKGR,0.01);
PFSEAPLANTLEG=PF_SEAFD_HI+PF_SEAFD_LOW+PF_SOY+PF_NUTSDS+PF_LEGUMES;
PFALLPROTLEG=PF_MPS_TOTAL+PF_EGGS+PF_NUTSDS+PF_SOY+PF_LEGUMES;
PFSEASOYNUT=round(PFSEAPLANTLEG - PF_LEGUMES,0.01);
PFMPEGGS=round(PFALLPROTLEG - PFSEAPLANTLEG,0.01);
IF PFMPEGGS<0 and PFMPEGGS ne . then PFMPEGGS=0;
IF VNONDRKGR<0 and VNONDRKGR ne . then VNONDRKGR=0;
IF PFSEASOYNUT<0 and PFSEASOYNUT ne . then PFSEASOYNUT=0;

LABEL DAY='Day of Recall'
      FWHOLEFRT='Whole Fruit'
	  VDRKGRLEG='Dark Green Vegetables and Legumes'
	  VTOTALLEG='Total Vegetables (inc Legumes)'
	  VNONDRKGR='Vegetables without Greens (w/o Legumes)'
  	  PFSEAPLANTLEG='Seafood and Plant Proteins (inc Legumes)'
	  PFALLPROTLEG='All Protein (inc Legumes)'
	  PFSEASOYNUT='Seafood, Soy, and Nuts (w/o Legumes)'
	  PFMPEGGS='Meat, Poultry, and Eggs (w/o Legumes)'  ;

keep SEQN DAY F_JUICE F_TOTAL PF_MPS_TOTAL V_DRKGR V_LEGUMES G_WHOLE G_REFINED D_TOTAL PF_LEGUMES ADD_SUGARS
F_CITMLB F_OTHER V_TOTAL PF_SEAFD_HI PF_SEAFD_LOW PF_SOY PF_NUTSDS PF_EGGS PF_TOTAL
FWHOLEFRT VDRKGRLEG VTOTALLEG VNONDRKGR PFSEAPLANTLEG PFALLPROTLEG PFSEASOYNUT PFMPEGGS;
run;

/**************************************************************************************************/
/*** 1a alternate step. If we only had foodcodes, and not merged data.  Shows how to make day 1 ***/
/**************************************************************************************************/

/*

libname food xport 'H:\Usual Intake\HEI\nhanes 1112\data\xpt\DR1IFF_G.XPT';
libname import 'H:\Usual Intake\HEI\nhanes 1112\data\';
libname fped 'H:\Usual Intake\HEI\nhanes 1112\fped';

proc copy in=food out=work;
 select DR1IFF_G;
run;

proc sort data=import.DR1IFF_G; by DR1IFDCD DR1MC; run;

data fped;
set fped.fped_1112(rename=(FOODCODE=DR1IFDCD MODCODE=DR1MC));
run;

DATA day1_foodcodes;
  merge import.DR1IFF_G(in=a) fped(rename=(F_JUICE=F_JUICE100 F_TOTAL=F_TOTAL100 PF_MPS_TOTAL=PF_MPS_TOTAL100 V_DRKGR=V_DRKGR100 V_LEGUMES=V_LEGUMES100 G_WHOLE=G_WHOLE100
  G_REFINED=G_REFINED100 D_TOTAL=D_TOTAL100 PF_LEGUMES=PF_LEGUMES100 ADD_SUGARS=ADD_SUGARS100 F_CITMLB=F_CITMLB100 F_OTHER=F_OTHER100 V_TOTAL=V_TOTAL100 PF_SEAFD_HI=PF_SEAFD_HI100
  PF_SEAFD_LOW=PF_SEAFD_LOW100 PF_SOY=PF_SOY100 PF_NUTSDS=PF_NUTSDS100 PF_EGGS=PF_EGGS100 PF_TOTAL=PF_TOTAL100));
  by DR1IFDCD DR1MC;
  if a;
  array compO(19) F_JUICE100 F_TOTAL100 PF_MPS_TOTAL100 V_DRKGR100 V_LEGUMES100 G_WHOLE100 G_REFINED100 D_TOTAL100 PF_LEGUMES100 ADD_SUGARS100
  F_CITMLB100 F_OTHER100 V_TOTAL100 PF_SEAFD_HI100 PF_SEAFD_LOW100 PF_SOY100 PF_NUTSDS100 PF_EGGS100 PF_TOTAL100;
  array comp(19) F_JUICE F_TOTAL PF_MPS_TOTAL V_DRKGR V_LEGUMES G_WHOLE G_REFINED D_TOTAL PF_LEGUMES ADD_SUGARS
  F_CITMLB F_OTHER V_TOTAL PF_SEAFD_HI PF_SEAFD_LOW PF_SOY PF_NUTSDS PF_EGGS PF_TOTAL;
  do i=1 to 19;
  comp[i]=round((compO[i]*DR1IGRMS / 100),0.01);
  end;
FWHOLEFRT=F_CITMLB+F_OTHER;
VDRKGRLEG=V_DRKGR+V_LEGUMES; 
VTOTALLEG=V_TOTAL+V_LEGUMES;
VNONDRKGR=round(V_TOTAL - V_DRKGR,0.01);
PFSEAPLANTLEG=PF_SEAFD_HI+PF_SEAFD_LOW+PF_SOY+PF_NUTSDS+PF_LEGUMES;
PFALLPROTLEG=PF_MPS_TOTAL+PF_EGGS+PF_NUTSDS+PF_SOY+PF_LEGUMES;
PFSEASOYNUT=round(PFSEAPLANTLEG - PF_LEGUMES,0.01);
PFMPEGGS=round(PFALLPROTLEG - PFSEAPLANTLEG,0.01);
IF PFMPEGGS<0 and PFMPEGGS ne . then PFMPEGGS=0;
IF VNONDRKGR<0 and VNONDRKGR ne . then VNONDRKGR=0;
IF PFSEASOYNUT<0 and PFSEASOYNUT ne . then PFSEASOYNUT=0;

LABEL FWHOLEFRT='Whole Fruit'
	  VDRKGRLEG='Dark Green Vegetables and Legumes'
	  VTOTALLEG='Total Vegetables (inc Legumes)'
	  VNONDRKGR='Vegetables without Greens (w/o Legumes)'
  	  PFSEAPLANTLEG='Seafood and Plant Proteins (inc Legumes)'
	  PFALLPROTLEG='All Protein (inc Legumes)'
	  PFSEASOYNUT='Seafood, Soy, and Nuts (w/o Legumes)'
	  PFMPEGGS='Meat, Poultry, and Eggs (w/o Legumes)'  ;

keep SEQN F_JUICE F_TOTAL PF_MPS_TOTAL V_DRKGR V_LEGUMES G_WHOLE G_REFINED D_TOTAL PF_LEGUMES ADD_SUGARS
F_CITMLB F_OTHER V_TOTAL PF_SEAFD_HI PF_SEAFD_LOW PF_SOY PF_NUTSDS PF_EGGS PF_TOTAL
FWHOLEFRT VDRKGRLEG VTOTALLEG VNONDRKGR PFSEAPLANTLEG PFALLPROTLEG PFSEASOYNUT PFMPEGGS;
run;

proc sort; by SEQN; run;

proc means noprint data=day1_foodcodes sum n; by seqn;
output out=day1_foods_sum sum=;
run; 

data day1_foods;
set day1_foods_sum;
DAY=1;
label DAY='Day of Recall';
run;

/**************************************************************************************************/
/**Note: This file does not include people without a recall, but the USDA file does;            ***/
/**Note: Would need to repeat code above for day 2;                                             ***/
/**************************************************************************************************/


/*** 1b.  Get nutrient data.  Nutrients have already been calculated using FNDDS for NHANES ***/

libname tot xport 'H:\Usual Intake\HEI\nhanes 1112\data\xpt\DR1TOT_G.XPT';
libname totb xport 'H:\Usual Intake\HEI\nhanes 1112\data\xpt\DR2TOT_G.XPT';


proc copy in=tot out=work;
 select DR1TOT_G;
run;

proc copy in=totb out=work;
 select DR2TOT_G;
run;



DATA day1_nutrients;
  SET DR1TOT_G(RENAME=(DR1DRSTZ=STATUS DR1DAY=DAY_WEEK DR1TMFAT=TMFAT DR1TPFAT=TPFAT DR1TSFAT=TSFAT DR1TSODI=TSODI DR1TKCAL=TKCAL));
  DAY=1;
  MONOPOLY=TMFAT+TPFAT;
  if (2 <= DAY_WEEK < = 5) then WEEKEND=0;
    else if DAY_WEEK NE . then WEEKEND=1;
  LABEL DAY='Day of Recall'
        WEEKEND='Indicator for Weekend Day (vs. Weekday)'
        MONOPOLY='MUFAs and PUFAs';
  KEEP SEQN DAY WEEKEND WTDRD1 WTDR2D STATUS  TMFAT TPFAT TSFAT TSODI TKCAL MONOPOLY;
run;


DATA day2_nutrients;
  SET DR2TOT_G(RENAME=(DR2DRSTZ=STATUS DR2DAY=DAY_WEEK DR2TMFAT=TMFAT DR2TPFAT=TPFAT DR2TSFAT=TSFAT DR2TSODI=TSODI DR2TKCAL=TKCAL)); 
  BY SEQN;
  DAY=2;
  MONOPOLY=TMFAT+TPFAT;
  if (2 <= DAY_WEEK < = 5) then WEEKEND=0;
    else if DAY_WEEK NE . then WEEKEND=1;
  LABEL DAY='Day of Recall'
        WEEKEND='Indicator for Weekend Day (vs. Weekday)'
        MONOPOLY='MUFAs and PUFAs';
  KEEP SEQN DAY WEEKEND WTDRD1 WTDR2D STATUS  TMFAT TPFAT TSFAT TSODI TKCAL MONOPOLY;
run;

DATA DAY1;
MERGE DAY1_FOODS DAY1_NUTRIENTS; 
BY SEQN;
RUN;

DATA DAY2;
MERGE DAY2_FOODS DAY2_NUTRIENTS; 
BY SEQN;
RUN;

/*** 1c.  Get demographic data ***/

libname demo xport 'H:\Usual Intake\HEI\nhanes 1112\data\xpt\DEMO_G.XPT';


proc copy in=demo out=work;
 select DEMO_G;
run;

DATA DEMO ;
  SET DEMO_G(keep=SEQN RIDAGEYR RIAGENDR SDDSRVYR SDMVPSU SDMVSTRA RIDRETH3);

  male=0;
  if riagendr=1 then male=1;

  age2_5=0;
  age6_11=0;
  age12_19=0;
  age20_39=0;
  age40_49=0;
  age50_59=0;
  age60_90=0;
  if (2 <= ridageyr <= 5) then age2_5=1;
   else if (6 <= ridageyr <= 11) then age6_11=1;
   else if (12 <= ridageyr <= 19) then age12_19=1;
   else if (20 <= ridageyr <= 39) then age20_39=1;
   else if (40 <= ridageyr <= 49) then age40_49=1;
   else if (50 <= ridageyr <= 59) then age50_59=1;
   else if (60 <= ridageyr <= 90) then age60_90=1;

  raceeth_nhbl=0;
  raceeth_asian=0;
  raceeth_hisp=0;
  if ridreth3=4 then raceeth_nhbl=1;
    else if ridreth3=6 then raceeth_asian=1;
    else if ridreth3 in (1,2) then raceeth_hisp=1;

run;


/*** 1d. ADD BRR WEIGHTS - this information is not available as stand alone ***/

libname brr 'H:\Usual Intake\HEI\HEI_deliverables_FromRuth_D20170713\data';

options nofmterr;

DATA BRR;
SET brr.marbrr;  ***insert file name here;
KEEP SEQN RepWt_0-RepWt_16;
RUN;

PROC SORT NODUPKEY; 
BY SEQN; 
RUN;

DATA RECALL;
SET DAY1 DAY2;
RECALLDAY2=(day=2);
IF WTDRD1 NE .;
IF STATUS=1;
RUN;

PROC SORT; 
BY SEQN DAY;
RUN;

DATA RECALL_DEMO;
MERGE RECALL(IN=A) DEMO; 
BY SEQN;
IF A;
IF RIDAGEYR>=2;
IF TKCAL NE .;  
RUN;

DATA FORHEI;
MERGE RECALL_DEMO (IN=A) BRR (IN=B); 
BY SEQN;
IF A AND B;
RUN;

PROC SORT DATA=FORHEI; 
BY SEQN DAY;
RUN;

DATA IMPORT.FORHEI;
SET FORHEI; 
RUN;

proc contents varnum data=IMPORT.FORHEI;
run;
